<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\Database\Exception\ExecutionFailureException;
use Joomla\CMS\Form\FormField;

class JFormFieldHikaShopOgImageField extends FormField
{
    public $type = 'HikaShopOgImageField';

    protected function getInput()
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true);

        try {
            $query
                ->select($db->quoteName(array('field_namekey', 'field_realname')))
                ->from($db->quoteName('#__hikashop_field'))
                ->where($db->quoteName('field_table') . " = 'product'");

            $db->setQuery($query);

            $options = $db->loadObjectList();
        } catch (ExecutionFailureException $e) {
            // the table does not exist
            $options = []; // Or handle this your preferred way
        }

        return $options;
    }
}
?>