<?php
/**
 * @package   Metatags Element for YOOtheme Pro
 * @author	dform https://dform.dk
 * @copyright Copyright (C) dform
 * @license   GNU General Public License version 3, or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;
use Joomla\CMS\Form\Form;
use YOOtheme\Application;

class plgSystemdf_metatags extends CMSPlugin
{
	public function onAfterInitialise()
	{
		if (!class_exists(Application::class, false)) {
			return;
		}
		$app = Application::getInstance();
		$app->load(__DIR__ . '/bootstrap.php');
	}


	public function onBeforeCompileHead()
	{
		$document 	= Factory::getDocument();

		// Schema company address and contact info added to the head section
		$schema = '
		{
		  "@context": "https://schema.org",
		  "@type": "Website",
		  "address": {
			"@type": "PostalAddress",
			"addressCountry": "'.$this->params->get('addressCountry').'",
			"addressLocality": "'.$this->params->get('addressLocality').'",
			"postalCode": "'.$this->params->get('postalCode').'",
			"streetAddress": "'.$this->params->get('streetAddress').'"
		  },
		  "url": "'.JURI::base().'",
		  "email": "'.$this->params->get('email').'",			  
		  "name": "'.$this->params->get('name').'",
		  "telephone": "'.$this->params->get('telephone').'"
		}
		';

		$document->addScriptDeclaration($schema, 'application/ld+json');

		$metatags = $this->params->get('metatags');
		if ($metatags) {
			foreach ($metatags as $metatag) {
				if ($metatag->published) {
					$type = ($metatag->type == 'name') ? 1 : '';
					$this->renderTag($metatag->value, $metatag->content, $type);
				}
			}
		}
	}

	public function onBeforeRender()
	{
		$app 		= Factory::getApplication();
		$document 	= Factory::getDocument();

		if ($app->isClient('site')) {
			$view		= $app->input->get('view'); // e.g. article, category, product. product view is product listing and can also contain categories in the YOOtheme template
			$context	= $app->input->get('option'); // e.g. com_content, com_hikashop
			$layout		= $app->input->get('layout');

			$active = $app->getMenu()->getActive();

			// product view
			if ($context == 'com_hikashop' && ($view == 'product' || $view == 'category') && $layout == 'show') {
				if (!@include_once(rtrim(JPATH_ADMINISTRATOR, DS) . DS . 'components' . DS . 'com_hikashop' . DS . 'helpers' . DS . 'helper.php')) {
					return false;
				}

				// Product
				$id 			= $app->input->get('cid'); // get current product id
				$productClass 	= hikashop_get('class.product');
				$fieldClass 	= hikashop_get('class.field');
				$product 		= $productClass->getProduct($id); // product

				// Product view
				if ($product) {
					$langTitle = $this->getLanguageTitle($product->produktland); // produktland = custom field on the product setting the language tag, e.g. da-DK

					if (!$product->product_page_title) {
						$this->seoTitle = $product->product_name . ' - ' . $langTitle;
					}

					if (html_entity_decode($product->product_page_title) == html_entity_decode($product->product_name)) {
						$this->seoTitle = $product->product_name . ' - ' . $langTitle;
					}

					$description 	= $product->product_meta_description;
					$canonicalUrl 	= JURI::base().ltrim($product->product_canonical, '/') . ''; // remove leading / from $product->product_canonical as it's added by JURI::base()
					$url 			= ($canonicalUrl) ? $canonicalUrl : JURI::getInstance()->toString(); // if canonical url is set, use that for image url

					// get custom image or first product image
					$customHikaImageField = $this->params->get("hika_custom_hika_og_image")[0];	// namekey of the field
					$image = ($product->{$customHikaImageField}) ? $product->{$customHikaImageField} : $product->images[0]->file_path; //Custom image with fallback to first product image

					// Handle path if custom image or first image from product
					if ($product->{$customHikaImageField}) {
						$field = $fieldClass->getField($customHikaImageField, 'product');
						$path = ($field->field_options['upload_dir']) ? $field->field_options['upload_dir'] : 'media/com_hikashop/upload/safe';
						$path = rtrim($path, '/') . '/'; // add trailing / if path doesn't have one.
						$path = ltrim($path, '/') . ''; // remove / from beginning as it's added by JURI::base()
					} else {
						$config = hikashop_config();
						$path = ltrim(JPath::clean(html_entity_decode($config->get('uploadfolder'))), DS);
					}

					if ($this->seoTitle) {
						$this->renderTag('og:title', $this->seoTitle, '');
					}
					if ($description) {
						$this->renderTag('og:description', $description, '');
					}
					if ($image) {
						$this->renderTag('og:image', JURI::base().$path.$image, '');
					}
					if ($url) {
						$this->renderTag('og:url', $url, '');
					}
				}
			}

			// Product listing aka category
			if ($context == 'com_hikashop' && ($view == 'product' || $view == 'category') && $layout == 'listing') {
				$menuItemParams = $active->getParams();
				$categoryId = isset($menuItemParams->get('hk_product')->category) ? $menuItemParams->get('hk_product')->category : '';

				if ($categoryId) {
					$categoryClass 	= hikashop_get('class.category');
					$category = new stdClass();
					$category = $categoryClass->get($categoryId); // category object

					//$fieldClass 	= hikashop_get('class.field');

					$title = $category->category_page_title;
					if ($title) {
						$this->renderTag('og:title', $title, '');
					}

					$description = $category->category_meta_description;
					if ($description) {
						$this->renderTag('og:description', $description, '');
					}
				}
				$url = JURI::getInstance()->toString();
				if ($url) {
					$this->renderTag('og:url', $url, '');
				}
			}
		}
	}

	public function onAfterRender()
	{
		$app = Factory::getApplication();

		// Check if the application is a site application.
		if ($app->isClient('site')) {
			// Get the view from the input.
			$view = $app->input->get('view');

			// Set the SEO title if defined.
			$title = !empty($this->seoTitle) ? $this->seoTitle : '';

			// Get the body of the response.
			$body = $app->getBody();

			// Use preg_replace to change the <title> tag content, ensuring the replacement is valid.
			if (!empty($title)) {
				$body = preg_replace('/<title>(.*?)<\/title>/i', '<title>' . htmlspecialchars($title, ENT_QUOTES, 'UTF-8') . '</title>', $body);
			}

			// Ensure the body content is correctly encoded.
			$app->setBody($body);
		}
	}

	public function onContentPrepare($context, &$article, &$params, $offset)
	{
	}

	// Articles and article categories
	public function onContentAfterDisplay($context, &$row, &$params, $page=0)
	{
		$app 		= Factory::getApplication();
		$document 	= Factory::getDocument();
		$view		= $app->input->get('view');
		$context	= $app->input->get('option');
		$url		= JURI::getInstance()->toString();
		$customFields = '';
		if ($context == 'com_content') {
			$title = $description = $image = '';

			if ($view == 'article') {

				// get custom fields in article view
				$this->customFields = FieldsHelper::getFields('com_content.'.$view, $row, true);
				$customFields = ($this->customFields) ? $this->getCustomFields($this->customFields) : '';

				//Get article title
				$title = $this->getTitle($this->params->get('article_title_type'), $customFields, $row);
				$this->seoTitle = $title;

				//Get article description
				$description = $this->getDescription($this->params->get('article_meta_description_type'), $customFields, $row);

				//Get article image
				$image = $this->getImage($this->params->get('article_og_image'), $customFields, $row);
				if (!$image) {
					$image = $this->params->get('article_fallback_image');
				}
			}

			if ($view == 'category') {

				// get custom fields in category view
				JLoader::register('FieldsHelper', JPATH_ADMINISTRATOR . '/components/com_fields/helpers/fields.php');
				$jcategories = JCategories::getInstance('Content');
				$category   = $jcategories->get($row->catid);

				$this->customFields = FieldsHelper::getFields('com_content.categories', $category, true);
				$customFields = ($this->customFields) ? $this->getCustomFields($this->customFields) : '';

				//Get category title
				$title = $this->getTitle($this->params->get('category_title_type'), $customFields, $category);

				//Get category description
				$description = $this->getDescription($this->params->get('category_meta_description_type'), $customFields, $category);

				//Get category image
				$image = $this->getImage($this->params->get('category_og_image'), $customFields, $category);
				if (!$image) {
					$image = $this->params->get('category_fallback_image');
				}
			}

			$type = $this->params->get('article_og_content_type');

			if ($title) {
				$this->renderTag('og:title', $title, '');
			}
			if ($description) {
				$this->renderTag('og:description', $description, '');
			}
			if ($image) {
				$this->renderTag('og:image', JURI::base().preg_replace('/#.*/', '', $image), '');
			}
			if ($url) {
				$this->renderTag('og:url', $url, '');
			}
			if ($type) {
				$this->renderTag('og:type', $type, '');
			}
		}
	}

	private function getLanguageTitle($langTag)
	{

		// Get all the site languages
		$languages = JLanguageHelper::getContentLanguages();

		// Get the native title of the current language
		$nativeTitle = '';
		foreach ($languages as $language) {
			if ($language->lang_code == $langTag) {
				$nativeTitle = $language->title_native;
				break;
			}
		}
		return $nativeTitle;
	}

	private function getTitle($titleType, $customFields, $row)
	{
		$title = '';
		$langTitle = ($row->language && $this->params->get('append_language_to_article_title')) ? ' - ' . $this->getLanguageTitle($row->language) : '';

		switch ($titleType) {

			case 1: //article title
				$title = $row->title;
				break;

			case 2: // article page title
				$title = $row->params->get('page_title');
				break;

			case 3: // custom field
				$title = $customFields->title;

				// If no title is set, and page title is set, use that
				if (!$title && is_object($row) && isset($row->params) && is_object($row->params) && method_exists($row->params, 'get')) {
					$title = $row->params->get('page_title');
				}

				// fallback to using the article title, append with language title
				if (!$title && $langTitle == 1) {
					$title = $row->title . $langTitle;
				}

				if (html_entity_decode($row->title) == html_entity_decode($title)) {
					$title = $row->title . $langTitle;
				} else {
					$title = $title;
				}

				break;

		}

		return $title;
	}

	private function getDescription($descriptionType, $customFields, $row)
	{
		$description = '';
		if (!$customFields) {
			return;
		}
		// $row->description for category description
		switch ($descriptionType) {

			case 1:
				$description = strip_tags($row->introtext);
				if (strlen($description) > 155) {
					$description = substr($description, 0, 155) .'...';
				}
				break;

			case 2:
				$description = $row->metadesc;
				break;

			case 3:
				$description = $customFields->description;
				break;

			case 4: // Category description
				$description = strip_tags($row->description);
				break;

			case 5: // Category meta description
				break;

		}

		return $description;
	}

	private function getImage($imageType, $customFields, $row)
	{
		switch ($imageType) {
			case 1:
				$image = json_decode($row->images)->image_intro;
				break;

			case 2:
				$image = json_decode($row->images)->image_fulltext;
				break;

			case 3: // custom image
				$image = $customFields->image;
				break;

			case 4: // Category image
				$image = json_decode($row->params)->image;
				break;

			case 5: // Category custom image
				$image = $customFields->image;
				break;
		}

		return $image;
	}

	public function getCustomFields($fields)
	{
		$view = Factory::getApplication()->input->get('view');
		$data = new stdClass();

		foreach ($fields as $field) {

			// Set the title if using a custom field
			if ($field->id == $this->params->get($view.'_custom_meta_title')) {
				$data->title = $field->value;
			}

			// Set description if using a custom field
			if ($field->id == $this->params->get($view.'_custom_meta_description')[0]) {
				$data->description = $field->value;
			}

			// Set img if using a custom field
			if ($field->id == $this->params->get($view.'_custom_og_image')[0]) {
				$data->image = json_decode($field->rawvalue)->imagefile;
			}
		}

		return $data;
	}

	public function renderTag($name, $value, $type = 1)
	{
		$document	= Factory::getDocument();

		// Encoded html tags can still be rendered, decode and strip tags first.
		$value		= strip_tags(html_entity_decode($value));

		// OG
		if ($type == 1) {
			$document->setMetadata(htmlspecialchars($name, ENT_COMPAT, 'UTF-8'), htmlspecialchars($value, ENT_COMPAT, 'UTF-8'));
		} else {
			$attributes = '';
			if ($name == 'og:image') {
				$attributes = ' itemprop="image"';
			}
			$document->addCustomTag('<meta property="'.htmlspecialchars($name, ENT_COMPAT, 'UTF-8').'"'.$attributes.' content="' . htmlspecialchars($value, ENT_COMPAT, 'UTF-8') . '" />');
		}
	}
}
